<?php

namespace WhatsAppModule;

class WhatsAppClient
{
    private HttpClient $http;
    private array $config;

    public function __construct(array $config)
    {
        $this->http = new HttpClient();
        $this->config = $config;
    }

    public function sendTemplate(
        string $to,
        string $templateName,
        string $lang,
        array $components
    ): array {
        $url = sprintf(
            '%s/%s/%s/messages',
            $this->config['base_url'],
            $this->config['api_version'],
            $this->config['phone_number_id']
        );

        $payload = [
            'messaging_product' => 'whatsapp',
            'to' => $to,
            'type' => 'template',
            'template' => [
                'name' => $templateName,
                'language' => ['code' => $lang],
                'components' => $components
            ]
        ];

        return $this->http->post($url, [
            'Authorization: Bearer ' . $this->config['access_token'],
            'Content-Type: application/json'
        ], $payload);
    }
}
