<?php

require '../src/HttpClient.php';
require '../src/WhatsAppClient.php';
require '../src/WebhookHandler.php';
require '../src/JsonStorage.php';

use WhatsAppModule\WhatsAppClient;
use WhatsAppModule\WebhookHandler;
use WhatsAppModule\JsonStorage;

$config = require '../config/whatsapp.php';

/**
 * ✅ Receive webhook JSON
 */
$webhook = new WebhookHandler();
$data = $webhook->getJson();

/**
 * ✅ Validate payload
 */
$required = [
    'project_name',
    'name',
    'mobile',
    'email',
    'receiver_number'
];

foreach ($required as $field) {
    if (empty($data[$field])) {
        http_response_code(400);
        exit("Missing: {$field}");
    }
}

/**
 * ✅ Normalize lead data
 */
$lead = [
    'project_name' => $data['project_name'],
    'name' => $data['name'],
    'mobile' => $data['mobile'],
    'email' => $data['email'],
    'receiver_number' => preg_replace('/\D/', '', $data['receiver_number']),
    'received_at' => date('Y-m-d H:i:s')
];

/**
 * ✅ Store in JSON
 */
$storage = new JsonStorage('../storage/leads.json');
$storage->append($lead);

/**
 * ✅ Send WhatsApp template
 */
$whatsapp = new WhatsAppClient($config);
$response = $whatsapp->sendTemplate(
    $lead['receiver_number'],
    'builder_notification',
    'en',
    [
        [
            'type' => 'body',
            'parameters' => [
                ['type' => 'text', 'text' => $lead['project_name']],
                ['type' => 'text', 'text' => $lead['name']],
                ['type' => 'text', 'text' => $lead['mobile']],
                ['type' => 'text', 'text' => $lead['email']]
            ]
        ]
    ]
);

/**
 * ✅ Log WhatsApp response
 */
file_put_contents(
    '../storage/whatsapp_response.log',
    json_encode($response) . PHP_EOL,
    FILE_APPEND
);

http_response_code(200);
echo 'SUCCESS';
